﻿using System;
using System.Collections.Generic;
using System.Linq;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
    public partial class DynamicDb : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        public DynamicDb()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods
        public List<TableColumnValue> GetFrameWorkTableByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID, Int32 PATIENT_ID, string CURRENT_FRAMEWORK_DATA) {
            List<TableColumnValue> objReturn = null;

            try {
                using (VIRPDBDataContext dbContext = GetDataContext()) {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REGISTRY_FRAMEWORK_DATA_getTableByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID, PATIENT_ID, CURRENT_FRAMEWORK_DATA).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex) {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;
        }

        public List<TableColumnValue> GetFrameWorkItemsByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID) {
            List<TableColumnValue> objReturn = null;

            try {
                using (VIRPDBDataContext dbContext = GetDataContext()) {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_REGISTRY_FRAMEWORK_DATA_getitemsByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex) {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;
        }

        #endregion
    }
}
